function Enemy(name, hp, mp, ap, exp, money, strength, speed, stamina, magic, type)
{
	this.name = name;
	this.hp = hp;
	this.maxhp = hp;
	this.mp = mp;
	this.maxmp = mp;
	this.ap = ap;
	this.exp = exp;
	this.money = money;
	this.strength = strength;
	this.speed = speed;
	this.stamina = stamina;
	this.magic = magic;
	this.elements = ElementArray();
	this.type = type;
	this.situation = "Normal";
	this.time = 0;
	this.attacks = new Array();
	this.sprite = LoadSpriteset(name + ".rss");
	this.ailments = AilmentArray();
	this.item = undefined;
	this.available = true;
}

Enemy.prototype.clone = function()
{
	var enemy = new Enemy(this.name, this.hp, this.mp, this.ap, this.exp, this.money, this.strength, this.speed, this.stamina, this.magic, this.type);
	enemy.elements = this.elements;
	enemy.attacks = this.attacks;
	return enemy;
}

Enemy.prototype.drawSprite = function()
{
	if (this.hp > this.maxhp * 0.25 && this.situation == "Normal")
	{
		this.sprite.images[15].blit(this.x, this.y);
	}
	if (this.hp <= this.maxhp * 0.25 && this.hp > 0 && this.situation == "Normal")
	{
		this.sprite.images[10].blit(this.x, this.y);
	}
}

Enemy.prototype.die = function()
{
	Game.curBattle.exp += this.exp;
	Game.curBattle.money += this.money;
	Game.curBattle.ap += this.ap;
	if (this.item != undefined)
	{
		this.item.add(this.item.amount, Game.curBattle.items);
	}
}

function Attack(cost, effect, rate)
{
	this.cost = cost;
	this.effect = effect;
	this.rate = rate;
}

var Enemies = new Object();
Enemies.Shitake = new Enemy("MM", 10, 0, 1, 3, 12, 2, 7, 2, 2, "Beast");
Enemies.Shitake.attacks[0] = new Attack(0, "");
Enemies.Jude = new Enemy("Jude", 32, 0, 3, 6, 12, 2, 7, 2, 2, "Human");